<?php
// Configuración de codificación
header('Content-Type: text/html; charset=UTF-8');
mb_internal_encoding('UTF-8');
session_start();
include('../clases/qr_clases.class.php');

$metodos = new actores();

// Asegurar que la salida sea UTF-8
if (!headers_sent()) {
    echo "\xEF\xBB\xBF"; // Agregar BOM para forzar UTF-8 en navegadores antiguos
}

// Configuración inicial
$pageTitle = "Verifica OIC";
$headerImage = "../../../pc/2025/src/img/logo.svg";

//$mensaje = (isset($_GET['v']))?$_GET['v']:'No hay solicitud de consulta!';
if(isset($_GET['v'])){
    $mensaje1 = $metodos->xss_clean($_GET['v']);
    $mensaje =" Validando consulta $mensaje1";
    $valida = $metodos->ver_query(false,"SELECT * FROM documentos_qrOIC WHERE qhash = '$mensaje1'");
    if(COUNT($valida)==1){
        $existe = true;
    }else{
        $existe = false;
    }
    
}else{
    $mensaje1="No hay solicitud de consulta";
};



?>

<!DOCTYPE html>
<html lang="es" class="h-100">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($pageTitle) ?></title>
    
    <!-- Bootstrap 5.3 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <style>
        .header-container {
            width: 100%;
            overflow: hidden;
            margin-bottom: 2rem;
        }
        
        .header-img {
            width: 30%; /* Ancho ajustado a porcentaje */
            max-width: 400px; /* Ancho máximo opcional */
            height: auto;
            display: block;
            margin: 0 auto;
            object-fit: contain;
        }

        @media (max-width: 768px) {
            .header-img {
                width: 85%; /* Mayor porcentaje en móviles */
            }
        }

        main {
            min-height: 50vh;
            padding: 2rem 0;
        }
        p{
            padding: 30px;
        }
    </style>
</head>
<body class="d-flex flex-column h-100" background-color:gray;color:white;>
    
    <!-- Contenedor de la imagen -->


    <div class="container">
            <div class="header-container">
        <img src="<?= htmlspecialchars($headerImage) ?>" 
             alt="Logo de <?= htmlspecialchars($pageTitle) ?>" 
             class="header-img">
    </div>

        <?php if($existe):
            $id_catdocumento = $valida[0][4];
        $documento = $metodos->ver_query(false,"SELECT nombre FROM cat_documentos where id = $id_catdocumento")[0][0];
            /*

        $breve = $documentos[1];*/
        /*
            [0] => 1
            [1] => 4
            [2] => 0
            [3] => 12
            [4] => 12
            [5] => 2025-05-29
            [6] => 2025-12-31
            [7] => 2025-05-29
            [8] => 2025-05-29 22:36:44
            [9] => 2025-05-29
            [10] => 2025-05-29
            [11] => 4
            [12] => OIC/a/2025/05/GAFO
            [13] => 683935dc7c74e1
            [14] => 1
            [15] => 2025
            [16] => 37
            [17] => 308890
            [18] => S
            [19] => DESARROLLO URBANO 
            [20] => DEPARTAMENTO DE INSPECCIÓN Y DILIGENCIAS
            [21] => CAMPUZANO/GONZALEZ/JUAN ROMAN
            [22] => ENCARGADO DE AREA C
            [23] => ACTIVO
            [24] => DEVUELTO 
            */
        $metodos->printP(false,$valida,'DATOS');
        $folio =$valida[0][16];
        $direccion =$valida[0][19];
        $departamento =$valida[0][20];
        $funcionario =$valida[0][21];
        $empleado =$valida[0][17];
        $puesto =$valida[0][22];
        $estado =$valida[0][23];
        ?>
        VERIFICA<br>
            <?php
            
            echo ("<p>
            $documento <br>
            AÑO : 2025 <br>
            FOLIO : $folio<br>
            <b>$funcionario</b><br>
            No. Empleado.<b> $empleado</b><br>$puesto<br><h2>$estado</h2><hr>
            $direccion<br>$departamento<hr>
            
            
            
            
            </p>"
            
            );
            ?>
            
        
        <?php else:?>
        <h2> SIN REGISTRO! </h2>
        <?php endif;?>

    </div>
    <!-- Footer -->
    <footer class="bg-dark text-white py-4 mt-auto">
        <div class="container text-center">
            <p class="mb-0">&copy; <?= date('Y') ?> <?= htmlspecialchars($pageTitle) ?></p>
            <p class="mt-2 small">Organo Interno de Control</p>
        </div>
    </footer>

    <!-- Bootstrap JS y Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>