<?php
// Configuracin de codificacin
header('Content-Type: text/html; charset=UTF-8');
mb_internal_encoding('UTF-8');
session_start();
include('clases/ver_diferencia.php');

$metodos = new actores();

// Asegurar que la salida sea UTF-8
if (!headers_sent()) {
    echo "\xEF\xBB\xBF"; // Agregar BOM para forzar UTF-8 en navegadores antiguos
}

// Configuracin inicial
$pageTitle = "Licencias Ambientales";
$headerImage = "src/img/logo.svg";

//$mensaje = (isset($_GET['v']))?$_GET['v']:'No hay solicitud de consulta!';
if(isset($_GET['v'])){
    $mensaje1 = $metodos->xss_clean($_GET['v']);
    $mensaje =" Validando consulta $mensaje1";
    $valida = $metodos->ver_query(false,"SELECT * FROM documentos_qr WHERE qhash = '$mensaje1'");
    if(COUNT($valida)==1){
        $existe = true;
    }else{
        $existe = false;
    }
    
}else{
    $mensaje1="No hay solicitud de consulta";
};



?>

<!DOCTYPE html>
<html lang="es" class="h-100">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($pageTitle) ?></title>
    
    <!-- Bootstrap 5.3 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <style>
        .header-container {
            width: 100%;
            overflow: hidden;
            margin-bottom: 2rem;
        }
        
        .header-img {
            width: 30%; /* Ancho ajustado a porcentaje */
            max-width: 800px; /* Ancho mximo opcional */
            height: auto;
            display: block;
            margin: 0 auto;
            object-fit: contain;
        }

        @media (max-width: 768px) {
            .header-img {
                width: 85%; /* Mayor porcentaje en mviles */
            }
        }

        main {
            min-height: 50vh;
            padding: 2rem 0;
        }
    </style>
</head>
<body class="d-flex flex-column h-100">
    
    <!-- Contenedor de la imagen -->
    <div class="header-container">
        <img src="<?= htmlspecialchars($headerImage) ?>" 
             alt="Logo de <?= htmlspecialchars($pageTitle) ?>" 
             class="header-img">
    </div>

    <div class="container">

        <?php if($existe):
        $id_doc = $valida[0][4];
        $documentos = $metodos->ver_query(false,"SELECT nombre,breve FROM cat_documentos WHERE id = $id_doc")[0];
        $folio = $valida[0][5];
        $vigencia = $valida[0][7];
        $giro= $valida[0][18];
        $historico = $valida[0][17];
        $razon = $valida[0][19];
        
        $documento= $documentos[0];
        $breve = $documentos[1];
        
        ?>
        <h2>
            <?php
            echo ("$documento <br
            $razon<br>
            GIRO : $giro<br>
            $breve : $historico <br>
            FOLIO : $folio  <br>
            VIGENCIA : 31-DICIEMBRE-2025
            "
            
            );
            ?>
            
        </h2>
        <?php else:?>
        <h2> SIN REGISTRO! </h2>
        <?php endif;?>

    </div>
    <!-- Footer -->
    <footer class="bg-dark text-white py-4 mt-auto">
        <div class="container text-center">
            <p class="mb-0">&copy; <?= date('Y') ?> <?= htmlspecialchars($pageTitle) ?></p>
            <p class="mt-2 small">Cuidando nuestro medio ambiente</p>
        </div>
    </footer>

    <!-- Bootstrap JS y Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>